@extends('store.layout.app')
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css">

@section ('content')
<div class="container-fluid">
    
 <div class="row">
<div class="col-lg-12">
    @if (session()->has('success'))
   <div class="alert alert-success">
    @if(is_array(session()->get('success')))
            <ul>
                @foreach (session()->get('success') as $message)
                    <li>{{ $message }}</li>
                @endforeach
            </ul>
            @else
                {{ session()->get('success') }}
            @endif
        </div>
    @endif
     @if (count($errors) > 0)
      @if($errors->any())
        <div class="alert alert-danger" role="alert">
          {{$errors->first()}}
          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">×</span>
          </button>
        </div>
      @endif
    @endif
    </div>
<div class="col-lg-12">
<div class="card">    
<div class="card-header card-header-primary">
      <h4 class="card-title ">Order by Photo List</h4>
    </div>
<div class="container"> <br> 
<table class="display" id="myTable">
    <thead>
        <tr>
            <th>#</th>
            <th>User</th>
            <th>Address</th>
            <th>Accept/Reject</th>
        </tr>
    </thead>
    <tbody>
           @if(count($list)>0)
          @php $i=1; @endphp
          @foreach($list as $user)
        <tr>
            <td class="text-center">{{$i}}</td>
            <td>{{$user->user_name}}<br>
           ({{$user->user_phone}})</td>
           <td>{{$user->receiver_name}},{{$user->house_no}},{{$user->landmark}},{{$user->state}},{{$user->pincode}}</td>
            <td class="td-actions text-right">
               @if($user->processed == 0)
                 <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal1{{$user->ord_id}}">View & Accept</button>
           <button type="button" class="btn btn-alert" data-toggle="modal" data-target="#exampleModal2{{$user->ord_id}}">Reject</button>
           @else
           <span style="color:green"><b>Accepted</b></span>
           @endif
            </td>
        </tr>
 <!--/////////Accept orders///////////-->        
<div class="modal fade" id="exampleModal1{{$user->ord_id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        	<div class="modal-dialog" role="document">
        		<div class="modal-content">
        			<div class="modal-header">
        				<h5 class="modal-title" id="exampleModalLabel"><b>View & Accept</b></h5>
        					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
        						<span aria-hidden="true">&times;</span>
        					</button>
        			</div>
        			<div class="container"> <br> 
                       <div class="col-lg-12">
                          <img src="{{url($user->list_photo)}}" style="width:200 !important;"> 
                       </div>
                       <a href="{{route('store_accept_order', $user->ord_id)}}"  class="btn btn-primary pull-center">Accept Order</a>
                     </div>  
        		
        		</div>
        	</div>
        </div>
        
<!-----reject order with cause ------->
 <div class="modal fade" id="exampleModal2{{$user->ord_id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        	<div class="modal-dialog" role="document">
        		<div class="modal-content">
        			<div class="modal-header">
        				<h5 class="modal-title" id="exampleModalLabel">Reject Order</h5>
        					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
        						<span aria-hidden="true">&times;</span>
        					</button>
        			</div>
        			<!--//form-->
        		<form class="forms-sample" action="{{route('store_reject_orderbyphoto', $user->ord_id)}}" method="post" enctype="multipart/form-data">
                      {{csrf_field()}}
        			<div class="row">
        			  <div class="col-md-3" align="center"></div>  
                      <div class="col-md-6" align="center">
                          <br>
                        <div class="form-group">
                           <label>Send Rejection Reason to User</label>    
        		     	   <textarea name="cause" row="5" required></textarea>
        			    </div>
        			<button type="submit" class="btn btn-primary pull-center">Submit</button>
        			</div>
        			</div>
        			  
                    <div class="clearfix"></div>
        			</form>
        		
        		</div>
        	</div>
        </div>
        
        
          @php $i++; @endphp
                 @endforeach
                  @else
                    <tr>
                      <td>No data found</td>
                    </tr>
                  @endif
    </tbody>
</table>
</div>  
</div>
</div>
</div>
</div>
<div>
    </div>
    <!--/////////reject orders///////////-->
 
<style>.buttons-html5 {
    color: white !important;
    background-color: #35d26d !important;
    border-radius: 5px;
    margin: 2px !important;
}
.buttons-print {
    color: white !important;
    background-color: #35d26d !important;
    border-radius: 5px;
    margin: 2px !important;
}</style>
<script>
        $(document).ready( function () {
    $('#myTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]});
} );
    </script>
    @endsection
</div>